%% 初期化
clear functions;
clear all;
close all;

%% start
tic;

%% パスの追加
addpath(genpath([pwd,'\PMWS_Simscape_Library']))

%% モデル実行
% シミュレーション時間を設定
end_time = 4500;

% パターン読み込み
load('test_input_nn_current.mat');

% モデルオープン
open_system('PMWG_HEV_Battery_Data_Acquisition');

% モデルの実行と結果保存
in = Simulink.SimulationInput('PMWG_HEV_Battery_Data_Acquisition');
out = sim(in,'ShowProgress','on');
save('PMWG_HEV_Battery_data_acquisition_simulation.mat',"out")

%% 事前準備
% 入力信号の調整
Current = squeeze(out.log.signals(2).values)';
SOCz1   = squeeze(out.log.signals(4).values)';
X_transient = [Current; SOCz1];

% 出力信号の調整
dSOC    = squeeze(out.log.signals(6).values)';
Voltage = squeeze(out.log.signals(3).values)';
Y_transient = [dSOC; Voltage];

% spliti Train Test
% 【課題】indexで分けているが、sim時間変更時など手動入力が必要
Index_train = 2 : 4500001*1/2;
X_train = X_transient(:, Index_train);
Y_train = Y_transient(:, Index_train);
Index_test = 2 : 4500001*1/2;
X_test = X_transient(:, Index_test);
Y_test = Y_transient(:, Index_test);

%% DeepLearningToolboxのLSTMを用いた学習
% 学習の実行
[testY_Pred, rmse, net, Xmu, Xsig, Ymu, Ysig] = learning_PMWG_function_LSTM1data(X_train,Y_train, X_test, Y_test);

% 保存
save('PMWG_HEV_Battery_net.mat','net')
save('PMWG_HEV_Battery_data_params.mat','X_transient', 'Y_transient', 'X_train','Y_train', 'X_test', 'Y_test', "Xmu","Xsig","Ymu","Ysig")

%% 検証
% モデルオープン
open_system('PMWG_HEV_Battery_Verification');

% 検証用モデルの実行
% 【課題】リアルタイムより時間がかかる 60秒のsimで約300秒必要（メモリ32GBのWindows-PC）
in_ver = Simulink.SimulationInput('PMWG_HEV_Battery_Verification');
out_ver = sim(in_ver,'ShowProgress','on');

%% end
toc;